<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section7
#  Version : R2.0.9.S01                                        
#  Intermediate release number : 014-20161025                                   
#  Last update : 03/06/2016                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:ted="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" exclude-result-prefixes="ted">
	<!---->
	<xsl:template match="*[@FORM='F14']//ted:CHANGE[local-name(ted:OLD_VALUE/*[1])!=local-name(ted:NEW_VALUE/*[1])]" mode="R800R801">
		<xsl:variable name="ele" select="concat('CHANGE[',position()-1,'][OLD_VALUE/',local-name(ted:OLD_VALUE/*[1]) ,' and NEW_VALUE/',local-name(ted:NEW_VALUE/*[1]),']')"/>
		<xsl:choose>
			<xsl:when test=".//ted:NOTHING and .//ted:CPV_MAIN">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R801'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTHING"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R800'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F14']//ted:CHANGE[.//ted:LOT_NO and .//ted:SECTION[matches(text(),'^((III)|(IV)|(VI))')]]" mode="R802">
		<xsl:variable name="ele" select="concat('CHANGE[',position()-1,'][WHERE/LOT_NO=',&quot;'&quot;,.//ted:LOT_NO,&quot;'&quot;,' and WHERE/SECTION=',&quot;'&quot;,.//ted:SECTION,&quot;'&quot;,']')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R802'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F20']//ted:DESCRIPTION_PROCUREMENT/ted:SHORT_DESCR" mode="R803">
		<xsl:choose>
			<xsl:when test="descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'DESCRIPTION_PROCUREMENT/SHORT_DESCR empty'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R803'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F20']//ted:INFO_MODIFICATIONS/ted:SHORT_DESCR" mode="R804">
		<xsl:choose>
			<xsl:when test="descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'NFO_MODIFICATIONS/SHORT_DESCR empty'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R804'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F20']//ted:INFO_MODIFICATIONS/ted:ADDITIONAL_NEED" mode="R805">
		<xsl:choose>
			<xsl:when test="descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'NFO_MODIFICATIONS/ADDITIONAL_NEED empty'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R805'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F20']//ted:INFO_MODIFICATIONS/ted:UNFORESEEN_CIRCUMSTANCE" mode="R806">
		<xsl:choose>
			<xsl:when test="descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'NFO_MODIFICATIONS/UNFORESEEN_CIRCUMSTANCE empty'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R806'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F14']//ted:CHANGES[not(.//ted:CPV_MAIN) and not(.//ted:CPV_ADDITIONAL) and not(.//ted:DATE)]" mode="R807">
		<xsl:choose>
			<xsl:when test=".//ted:TEXT/descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:when test=".//ted:INFO_ADD/descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'INFO_ADD empty'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R807'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
